@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();

    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];

    // Define color theme for this email
    $themeColor = '#22C55E'; // Green
    $themeBackground = 'linear-gradient(135deg, #D1FAE5 0%, #A7F3D0 100%)';
    $themeIcon = '🔑';

    // Helper function to safely get settings

@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: #fff !important;
            text-align: left;
            position: relative;
        }

        #email-header::after {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100%;
            background:  #fff !important;
            transform: skew(-15deg);
            transform-origin: top right;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: white;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        #email-content {
            padding: 25px 30px;
            color: #333333;
        }

        .greeting-section {
            font-size: 16px;
            margin-bottom: 12px;
            color: #6b7280;
        }

        .greeting-section strong {
            color: #1f2937;
            font-weight: 600;
        }

        .notification-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 15px;
            color: {{ $themeColor }};
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .notification-title::before {
            content: "{{ $themeIcon }}";
            font-size: 20px;
        }

        .alert-box {
            background: {{ $themeBackground }};
            border: 1px solid {{ $themeColor }};
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 15px;
            position: relative;
        }

        .alert-box::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: {{ $themeColor }};
            border-radius: 4px 0 0 4px;
        }

        .alert-box p {
            margin: 0;
            font-size: 14px;
            color: #1E40AF;
            font-weight: 500;
        }

        .info-card {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            position: relative;
        }

        .info-card h3 {
            color: #1f2937;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 15px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .credentials-details h3::before {
            content: '🔐';
            font-size: 18px;
        }

        .info-card p {
            margin-bottom: 6px;
            font-size: 13px;
            color: #374151;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .info-card p:last-child {
            margin-bottom: 0;
        }

        .info-card strong {
            font-weight: 600;
            color: #1f2937;
            min-width: 120px;
        }

        .info-value {
            font-weight: 500;
            color: #4b5563;
        }

        .highlight {
            background: {{ $themeBackground }};
            color: #1E40AF !important;
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: 600;
        }

        .email-content-area p {
            font-size: 13px;
            margin-bottom: 10px;
            line-height: 1.45;
        }
        .app-download {
            margin-top: 10px;
        }

        .store-card {
            display: inline-block;
            background: #0f172a;
            padding: 0px 10px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }

        .store-badge {
            display: inline-block;
            line-height: 0;
        }

        .store-caption {
            font-size: 10px;
            color: #6b7280;
            margin-top: 6px;
            text-align: center;
        }
        .action-button {
            display: inline-block;
            background-color: {{ $themeColor }};
            color: white !important;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 6px;
            font-weight: 600;
            margin: 10px 0;
            text-align: center;
            font-size: 13px;
        }

        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent 0%, #e5e7eb 50%, transparent 100%);
            margin: 15px 0;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 12px;
            text-align: center;
            font-size: 11px;
            color: #6b7280;
        }

        .big-tagline {
            margin-top: 4px;
            font-size: 12px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            padding: 15px;
            text-align: center;
        }

        .footer-logo {
            height: 30px;
            margin-bottom: 8px;
        }

        .company-title {
            font-size: 13px;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 6px;
        }

        .company-address-contact {
            font-size: 11px;
            color: #6b7280;
            line-height: 1.4;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 15px;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" alt="WMS Logo" />
            @else
                <h2>{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <strong>{{ $name }}</strong>
            </div>

            <div class="notification-title">
                Welcome to {{ $companyName }}!
            </div>

            <div class="info-card credentials-details">
                <h3>Your Login Credentials</h3>
                <div class="alert-box" style="margin: 0 0 10px 0; padding: 10px;">
                    <p style="margin: 0; font-size: 12px;"><strong>🔐 Security Notice:</strong> Your admin has updated your credentials. Please login using these new credentials and change your password immediately after first login for security.</p>
                </div>
                <p><strong>Email:</strong> <span class="info-value">{{ $email }}</span></p>
                <p><strong>Password:</strong> <span class="highlight">{{ $password }}</span></p>
            </div>

            <div class="email-content-area">
                <p><strong>Important:</strong> Use the credentials above to login immediately and update your password.</p>

                @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
                    <div class="app-download">
                        <div style="text-align: center;">
                            @if (env('APP_LINK_APPSTORE'))
                                <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                                    rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                                    <span class="store-badge">
                                        <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                            alt="Get it on Google Play"
                                            style="height: 42px; width: auto; border: 0; display: block;">
                                    </span>
                                </a>
                            @endif
                            @if (env('APP_LINK_APPSTORE_Apple'))
                                <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                                    rel="noopener"
                                    style="background: #000000; padding: 10px 12px; border-radius: 8px; display: inline-block; vertical-align: middle; text-decoration: none;">
                                    <table role="presentation" cellpadding="0" cellspacing="0" border="0"
                                        style="margin: 0; padding: 0;">
                                        <tr>
                                            <td style="padding: 0 6px 0 0; vertical-align: middle;">
                                                <img src="https://img.icons8.com/?size=100&id=30840&format=png&color=FFFFFF"
                                                    alt="Apple"
                                                    style="width: 20px; height: 20px; display: block; border: 0;">
                                            </td>
                                            <td style="padding: 0; vertical-align: middle;">
                                                <div
                                                    style="color: #FFFFFF; font-size: 8px; letter-spacing: 0.5px; line-height: 10px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 400;">
                                                    Download on the</div>
                                                <div
                                                    style="color: #FFFFFF; font-size: 14px; line-height: 16px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 600; margin-top: 2px;">
                                                    App Store</div>
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            @endif
                        </div>
                        <div class="store-caption">Tap to download our mobile app</div>
                    </div>
                @endif

                <div class="divider"></div>


                <p class="thank-you">Welcome aboard!<br>{{ $companyName }} Team</p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <div class="big-tagline">
                    For any questions, contact support
                    @if ($companyEmail)
                        <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                    @endif
                </div>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br />
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
