@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();

    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];


    // Define color theme for this email
    $themeColor = '#22C55E'; // Green
    $themeBackground = 'linear-gradient(135deg, #D1FAE5 0%, #A7F3D0 100%)';
    $themeIcon = '🔑';

    // Helper function to safely get settings

@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: #fff !important;
            text-align: left;
            position: relative;
        }

        #email-header::after {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100%;
            background: #fff !important;
            transform: skew(-15deg);
            transform-origin: top right;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: white;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        #email-content {
            padding: 42px 34px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
            color: #6b7280;
        }

        .greeting-section strong {
            color: #1f2937;
            font-weight: 600;
        }

        .notification-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 20px;
            color: {{ $themeColor }};
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .notification-title::before {
            content: "{{ $themeIcon }}";
            font-size: 24px;
        }

        .alert-box {
            background: {{ $themeBackground }};
            border: 1px solid {{ $themeColor }};
            border-radius: 8px;
            padding: 16px;
            margin-bottom: 24px;
            position: relative;
        }

        .alert-box::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: {{ $themeColor }};
            border-radius: 4px 0 0 4px;
        }

        .alert-box p {
            margin: 0;
            font-size: 14px;
            color: #065F46;
            font-weight: 500;
        }

        .info-card {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            position: relative;
            transition: transform 0.2s ease;
        }

        .info-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .info-card h3 {
            color: #1f2937;
            margin-bottom: 12px;
            font-weight: 600;
            font-size: 16px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .credentials-details h3::before {
            content: '🔑';
            font-size: 18px;
        }

        .info-card p {
            margin-bottom: 8px;
            font-size: 14px;
            color: #374151;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .info-card p:last-child {
            margin-bottom: 0;
        }

        .info-card strong {
            font-weight: 600;
            color: #1f2937;
            min-width: 120px;
        }

        .info-value {
            font-weight: 500;
            color: #4b5563;
        }

        .highlight {
            background: {{ $themeBackground }};
            color: #065F46 !important;
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: 600;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
            color: #4b5563;
        }

        .action-button {
            display: inline-block;
            background-color: {{ $themeColor }};
            color: white !important;
            text-decoration: none;
            padding: 12px 24px;
            border-radius: 6px;
            font-weight: 600;
            margin: 15px 0;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            transition: background-color 0.2s ease;
        }

        .action-button:hover {
            background-color: #16A34A;
        }

        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent 0%, #e5e7eb 50%, transparent 100%);
            margin: 24px 0;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 16px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }

        .big-tagline {
            margin-top: 8px;
            font-size: 14px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 700;
            text-decoration: none;
        }

        .company-details {
            padding: 20px;
            text-align: center;
        }

        .footer-logo {
            height: 35px;
            margin-bottom: 12px;
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 8px;
        }

        .company-address-contact {
            font-size: 12px;
            color: #6b7280;
            line-height: 1.5;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" alt="WMS Logo" />
            @else
                <h2>{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <strong>{{ $name }}</strong>
            </div>

            <div class="notification-title">
                Your Password Has Been Reset
            </div>

            <div class="alert-box">
                <p>
                    Your account password has been reset by an administrator. Please use the new credentials to log in.
                </p>
            </div>

            <div class="info-card credentials-details">
                <h3>Login Credentials</h3>
                <p><strong>Email:</strong> <span class="info-value">{{ $email }}</span></p>
                <p><strong>New Password:</strong> <span class="highlight">{{ $password }}</span></p>
            </div>

            <div class="email-content-area">
                <p>For your security, we recommend changing this password after logging in to something you can easily
                    remember.</p>

                <a href="{{ env('FRONTEND_URL')}}" class="action-button">Login to Your Account</a>

                <div class="divider"></div>

                <p>If you did not request this password reset, please contact our support team immediately.</p>

                <p class="thank-you">Thank you,<br>{{ $companyName }} Team</p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p>This is an auto-generated email. Please do not reply to this email.</p>
                <div class="big-tagline">
                    For any questions, contact support
                    @if ($companyEmail)
                        <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                    @endif
                </div>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br />
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
